<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PaymentType;
use App\Models\PaymentMethod;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class PaymentTypeController extends Controller
{
    //
    public function allPaymentType() {
        $allData = PaymentType::all();
        $paymentmethod = PaymentMethod::all();
        return view('admin.paymenttype.payment_type_all',compact('allData','paymentmethod'));
    }
    // End of method

    public function addPaymentType() {

        $paymentmethod = PaymentMethod::all();
        return view('admin.paymenttype.payment_type_add',compact('paymentmethod'));
    }
    // End of method

    public function storePaymentType(Request $request) {

        PaymentType::insert([
            'name' => $request->name,
            'paymentmethod_id' => $request->paymentmethod_id,
            'created_by' => Auth::user()->id,
            'created_at' => Carbon::now(),
        ]);

        $notification = array(
            'message' => 'Payment Type added successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('paymenttype.all')->with($notification);
    }
    // End of method

    public function editPaymentType($id) {
        $paymenttype = PaymentType::findOrFail($id);
        $paymentmethod = PaymentMethod::all();
        return view('admin.paymenttype.payment_type_edit', compact('paymenttype','paymentmethod'));
    }

    public function updatePaymentType(Request $request) {

        $request_id = $request->id;
        $unit = PaymentType::findOrFail($request_id)->update([
            'name' => $request->name,
            'paymentmethod_id' => $request->paymentmethod_id,
            'updated_by' => Auth::user()->id,
            'updated_at' => Carbon::now(),
        ]);

        $notification = array(
            'message' => 'Payment Type Updated successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('paymenttype.all')->with($notification);
    } // End of method

    public function deletePaymentType($id) {

        PaymentType::findOrFail($id)->delete();

        $notification = array(
            'message' => 'Payment Type deleted successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('paymenttype.all')->with($notification);
    }
    // End of method
}
