<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Akiba;
use App\Models\User;
use App\Models\PaymentMethod;
use App\Models\PaymentType;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class AkibaController extends Controller
{
    ////
    public function addAkiba() {

        $allusers = User::all();
        $pmethod = PaymentMethod::all();
        $ptype = PaymentType::all();

        return view('admin.akiba.akiba_add',compact('allusers','pmethod','ptype'));
        
    }
    // End of method

    public function paymentAkiba(Request $request) {

        $allusers = User::all();
        $pmethod = PaymentMethod::all();
        $ptype = PaymentType::all();

        if($request->file('risit_image')) {
            $manager = new ImageManager(new Driver());
            $name_gen = hexdec(uniqid()).'.'.$request->file('risit_image')->getClientOriginalExtension();
            $img = $manager->read($request->file('risit_image'));
            $img = $img->resize(1029,519);
            $img->toJpeg(100)->save('upload/akiba/risit/'.$name_gen);
            $save_url = 'upload/akiba/risit/'.$name_gen;
        

        Akiba::insert([
            'member_id' => $request->member_id,
            'paymentmethod_id' => $request->paymentmethod_id,
            'paymenttype_id' => $request->paymenttype_id,
            'amount' => $request->amount,
            'pdate' => $request->pdate,
            'risiti' => $save_url,
            'created_by' => Auth::user()->id,
            'created_at' => Carbon::now(),
        ]);
    }

        $notification = array(
            'message' => 'Akiba record stored successfully',
            'alert-type' => 'success',
        );
        return view('admin.akiba.akiba_add',compact('allusers','pmethod','ptype'));
        
    }
    // End of method

    public function pendingakiba() {
        $all_users = User::all();
        $pending = Akiba::all()->where('status',0);
        return view('admin.akiba.akiba_pending', compact('pending','all_users'));
    }
    // End of method

    public function reviewakiba($id) {
        $a_review = Akiba::findOrFail($id);
        $all_users = User::where('id', $a_review->member_id)->get();
        $p_type = PaymentType::where('id', $a_review->paymenttype_id)->get();
        return view('admin.akiba.akiba_payment_approval', compact('a_review','all_users','p_type'));
    }
    // End of method

    public function approvedakiba(Request $request) {
        $request_id = $request->id;
        $a_approved = Akiba::findOrFail($request_id)->update([
            'status' => 1,
            'updated_by' => Auth::user()->id,
            'updated_at' => Carbon::now(),
        ]);

        $notification = array(
            'message' => 'Akiba approved successfully',
            'alert-type' => 'success',
        );
        return redirect()->route('pendingakiba')->with($notification);
    }
    // End of method

    public function rejectakiba(Request $request) {
        $request_id = $request->id;
        $a_rejected = Akiba::findOrFail($request_id)->update([
            'status' => '2',
            'reason' => $request->reason,
            'updated_by' => Auth::user()->id,
            'updated_at' => Carbon::now(),
        ]);
    }
    // End of method
}
